'/**************************************/;
'/* Program Demo For ET-ROBOT RD2 V1.0 */;
'/* Controller  : P89C51RD2(Philips)   */;
'/* Run X-TAL   : 18.432 Mhz           */;
'/*             : X2 Mode(6 Cycle Run) */;
'/* Complier    : BASCOM-51(V2.0.11.0) */;
'/* Write By    : Eakachai Makarn      */;
'/* File Update : December-2003        */;
'/* Used CONFIG SERVOS...Control Servo */;
'/**************************************/;
'
$regfile = "89c51rd.dat"                                      'P89C51RD2(Philips)
$ramstart = 0
$ramsize = 256
$crystal = 36864000                                           '18.432MHz (X2 Mode)

Config Servos = 2 , Servo1 = P1.4 , Servo2 = P1.5 , Reload = 0
Declare Sub Robot_forward                                     'Forward Direction
Declare Sub Robot_backward                                    'Backward Direction
Declare Sub Robot_fast_left                                   'Turn Left Fast
Declare Sub Robot_slow_left                                   'Turn Left Slow
Declare Sub Robot_fast_right                                  'Turn Right Fast
Declare Sub Robot_slow_right                                  'Turn Right Slow
Declare Sub Robot_stop                                        'Robot Stop

Robot_stop                                                    'Stop Robot & Wait Switch-Start
Bitwait P0.2 , Reset                                          'Wait Until SW-Start Press (P0.2="0")

Do
  Robot_forward                                               'ROBOT is Forward
  Wait 1
  Robot_stop                                                  'ROBOT is Stop
  Wait 1
  Robot_backward                                              'ROBOT is Backward
  Wait 1
  Robot_stop                                                  'ROBOT is Stop
  Wait 1
  Robot_fast_right                                            'ROBOT is Fast Turn-Right
  Wait 1
  Robot_stop                                                  'ROBOT is Stop
  Wait 1
  Robot_fast_left                                             'ROBOT is Fast Turn-Left
  Wait 1
  Robot_stop                                                  'ROBOT is Stop
  Wait 1
  Robot_slow_right                                            'ROBOT is Slow Turn-Right
  Wait 4
  Robot_stop                                                  'ROBOT is Stop
  Wait 1
  Robot_slow_left                                             'ROBOT is Slow Turn-Left
  Wait 4
  Robot_stop                                                  'ROBOT is Stop
  Wait 1
Loop


'/*****************/;
'/* ROBOT Forward */;
'/*****************/;
'
Sub Robot_forward                                             'Forward Direction
  Servo1 = 24                                                 'Servo Left  = 2mS Pulse High = Forward
  Servo2 = 12                                                 'Servo Right = 1mS Pulse High = Forward
End Sub

'/******************/;
'/* ROBOT Backward */;
'/******************/;
'
Sub Robot_backward                                            'Backward Direction
  Servo1 = 12                                                 'Servo Left  = 1mS Pulse High = Backward
  Servo2 = 24                                                 'Servo Right = 2mS Pulse High = Backward
End Sub

'/*************************/;
'/* ROBOT Turn Left(Fast) */;
'/*************************/;
'
Sub Robot_fast_left                                           'Turn Left Fast
  Servo1 = 12                                                 'Servo Left  = 1mS Pulse High = Backward
  Servo2 = 12                                                 'Servo Right = 1mS Pulse High = Forward
End Sub

'/*************************/;
'/* ROBOT Turn Left(Slow) */;
'/*************************/;
'
Sub Robot_slow_left                                           'Turn Left Slow
  Servo1 = -1                                                 'Servo Left  = "1" = Stop
  Servo2 = 12                                                 'Servo Right = 1mS Pulse High = Forward
End Sub

'/**************************/;
'/* ROBOT Turn Right(Fast) */;
'/**************************/;
'
Sub Robot_fast_right                                          'Turn Right Fast
  Servo1 = 24                                                 'Servo Left  = 2mS Pulse High = Forward
  Servo2 = 24                                                 'Servo Right = 2mS Pulse High = Backward
End Sub

'/**************************/;
'/* ROBOT Turn Right(Slow) */;
'/**************************/;
'
Sub Robot_slow_right                                          'Turn Right Fast
  Servo1 = 24                                                 'Servo Left  = 2mS Pulse High = Forward
  Servo2 = -1                                                 'Servo Right = "1" = Stop
End Sub

'/**************/;
'/* ROBOT Stop */;
'/**************/;
'
Sub Robot_stop                                                'Robot Stop
  Servo1 = -1                                                 'Servo Left  = "1" = Stop
  Servo2 = -1                                                 'Servo Right = "1" = Stop
End Sub

End